  

---

### 1. Cisco Cloudlock Overview

- **What It Is:**
    - Cisco Cloudlock is a cloud-native, out-of-band, API-based CASB solution.
    - Uses public APIs of XaaS (SaaS, PaaS, IaaS) platforms for security integration.
    - Co-developed APIs with cloud vendors; supports many public cloud platforms.

---

### 2. Advantages of Cisco Cloudlock

- **Out-of-Band, API-Based:**
    - No need to sit in the user traffic path (unlike proxy-based CASB).
    - No proxy sizing or rules maintenance required.
    - No rerouting of application traffic.
    - Fast deployment—can be set up in minutes.
    - Not directly exposed to DoS attacks or proxy evasion.
- **Easy Integration:**
    - Example: Integrate with Google+ by installing the Cloudlock app and granting API access.
    - Predefined policies for quick activation and accurate incident detection.

---

### 3. Key Capabilities

#### A. Securing Users and Accounts

- Uses User and Entity Behavior Analytics (UEBA) to detect suspicious activities.
- Identifies impossible travel or abnormal user behavior (e.g., logins from distant locations in short timeframes).
- Detects compromised accounts even if traditional security controls are not violated.

#### B. Securing Cloud Data

- Data Loss Prevention (DLP) functionality checks documents and messages for sensitive data (e.g., credit card numbers, account numbers).
- Alerts both IT and the user who uploads sensitive or regulated information.
- DLP extends beyond storage to services like chat applications (e.g., Slack).

#### C. Securing Cloud Applications

- Apps Firewall discovers and controls OAuth-connected apps in the environment.
- Notifies administrators of new risky app integrations and enables easy revocation or approval.

#### D. Auditing and Forensics

- Aggregates audit logs from multiple cloud apps for holistic monitoring.
- Supports investigation of specific user actions, including privileged users.

#### E. Encryption Management

- Selective, content-aware AES 256-bit encryption for data in cloud platforms.
- Can automatically encrypt sensitive data in response to DLP policy violations.
- Enhances data protection, especially for accidental or intentional data exposure.

---

### 4. Cisco Cloudlock Deployment & Offerings

- **Unified Service:**
    - Protects users, data, and applications across platforms like Office 365, G Suite, Salesforce, Dropbox, Box, ServiceNow, Webex, Slack, and more.
- **Two Main Offers:**
    - Cisco Cloudlock CASB Security Platform (general market)
    - Cisco Cloudlock CASB Security Platform for Federal (with enhanced compliance for government needs, e.g., FedRAMP)

---

**Key Takeaways:**

- Cisco Cloudlock enables organizations to secure cloud users, data, and applications without affecting user experience or cloud app operation.
- It provides advanced security features, including UEBA, DLP, app discovery/control, audit, forensics, and automated encryption—all managed through an out-of-band, API-based approach.
- Rapid deployment, easy integration, and broad platform support make Cloudlock a powerful CASB solution for today’s multi-cloud environments.